/**
* \file: am_api_control.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AM_API_CONTROL_H
#define AM_API_CONTROL_H

#include <stdbool.h>

#include "automounter_api_ctrl.h"
#include "ipc/info_messages.h"

error_code_t am_api_control_remount_partition_by_mountpoint(const char *mountpoint,const char *options,
		int request_id, request_done_callback_t done_callback_func);

error_code_t am_api_control_remount_partition_by_id(const char *partition_id,const char *options,
		int request_id, request_done_callback_t done_callback_func);

error_code_t am_api_control_umount_device(const char *device_id,
		int request_id, request_done_callback_t done_callback_func);

error_code_t am_api_control_umount_partition_by_id(const char *partition_id,
		int request_id, request_done_callback_t done_callback_func);

error_code_t am_api_control_umount_partition_by_mountpoint(const char *mount_point,
		int request_id, request_done_callback_t done_callback_func);

error_code_t am_api_control_get_snapshot(snapshot_scope_t scope, int request_id);

void am_api_control_send_application_info(const char *app_info, event_mask_t event_mask);

#endif
